#ILI9488 uses 24bit mode
COLOUR_BLACK  = const(0x000000)
COLOUR_WHITE  = const(0xFFFFFF)
COLOUR_RED    = const(0xFF0000)
COLOUR_GREEN  = const(0x00FF00)
COLOUR_BLUE   = const(0x0000FF)
COLOUR_YELLOW = const(0xFFFF00)
COLOUR_CYAN   = const(0x00FFFF)
COLOUR_MAGENTA= const(0xFF00FF)
COLOUR_GREY   = const(0x808080)

import utime
from ILI9488LIB import ILI9488LIB
from ILI9488LIB import LCD_BUTTON
import LSNBFONT

display = ILI9488LIB()       #use defaults
display.init()               #init
display.setRotation(2)

red=LCD_BUTTON(10,280,100,35,"RED")
green=LCD_BUTTON(130,280,100,35,"GREEN")
blue=LCD_BUTTON(250,280,100,35,"BLUE")
erase=LCD_BUTTON(370,280,100,35,"ERASE")
c=COLOUR_WHITE

def drawDemo():
    display.clear(COLOUR_BLACK)
    display.drawstr((display.width-display.strwidth("Testing",LSNBFONT))//2,20,"Testing",LSNBFONT,COLOUR_WHITE,COLOUR_BLUE)
    display.fcircle(100,100,20,COLOUR_YELLOW)
    display.fcircle(100,100,15,COLOUR_RED)
    display.circle(100,100,45,COLOUR_CYAN)
    display.box(280,80,320,120,COLOUR_YELLOW)
    display.box(285,85,315,115,COLOUR_RED)
    display.hbox(255,55,345,145,COLOUR_CYAN)
    display.button(red)
    display.button(green)
    display.button(blue)
    display.button(erase)
    
drawDemo()
lastx=-1
lasty=-1

while 1:
    x=display.touchx()
    y=display.touchy()
    if (x>=0 and y>=0 and lastx>=0 and lasty >=0):
        display.line(x,y,lastx,lasty,c)
    lastx=x
    lasty=y
    display.check(red)
    if(red.lastchange != 0):
        display.button(red)
        c=COLOUR_RED
    display.check(green)
    if(green.lastchange != 0):
        display.button(green)
        c=COLOUR_GREEN
    display.check(blue)
    if(blue.lastchange != 0):
        display.button(blue)
        c=COLOUR_BLUE
    display.check(erase)
    if(erase.lastchange != 0):
        display.button(erase)
    if(erase.lastchange == -1):
        drawDemo()
